**************************************************************************************************
*******************LOCAL INCOME INEQUALITY AND HOUSEHOLD INDEBTEDNESS ****************************
*************************REGRESSION ANALYSIS *****************************************************
*************************DATE: JAN 2022 **********************************************************
*************************AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

//Load data
use "UnbalancedHH_analytical.dta", clear

//Global vars
global DemCovar "age age2 sex Luni Lkids Ladults Lmarried Lemp Lnilf Lselfemp Duni Dkids Dadults Dmarried Demp Dnilf Dselfemp"
global FinCovar "Lginc Dginc Lassets Dassets Lfinassets Dfinassets Lliqnworth Dliqnworth"
global MacroCovar "Lmedhp Dmedhp Lurate Durate Lmedinc Dmedinc Lmeddebt Dmeddebt"

//TABLE B5: Robustness Checks with Interaction Controls
//Panel A: Effects on Investment Debt and Car Debt - by Income Quantile

*Investment debt
eststo m1: quietly xtreg Dinvdebttoinc c.dgini#i.Lincgn i.Lincgn $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m2: quietly xtreg Dcardebttoinc c.dgini#i.Lincgn i.Lincgn $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//Panel B: Effects on Investment Debt and Car Debt - by Financial Prosperity

*Investment debt
eststo m3: quietly xtreg Dinvdebttoinc c.dgini#i.Lselfrank i.Lselfrank $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lselfrank i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m4: quietly xtreg Dcardebttoinc c.dgini#i.Lselfrank i.Lselfrank $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lselfrank i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//Panel C: Effects on Investment Debt and Car Debt - by Life Cycle

*Investment debt
eststo m5: quietly xtreg Dinvdebttoinc c.dgini#i.Lageg i.Lageg $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lageg i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m6: quietly xtreg Dcardebttoinc c.dgini#i.Lageg i.Lageg $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lageg i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//Panel D: Effects on Investment Debt and Car Debt - by Housing Status

*Investment debt
eststo m7: quietly xtreg Dinvdebttoinc c.dgini#i.Lhsa i.Lhsa $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lhsa i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m8: quietly xtreg Dcardebttoinc c.dgini#i.Lhsa i.Lhsa $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lhsa i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//Panel E: Effects on Investment Debt and Car Debt - by Htm

*Investment debt
eststo m9: quietly xtreg Dinvdebttoinc c.dgini#i.Lhtm i.Lhtm $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lhtm i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m10: quietly xtreg Dcardebttoinc c.dgini#i.Lhtm i.Lhtm $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lhtm i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//Panel F: Effects on Investment Debt and Car Debt - by Ability to Raise Money Easily

*Investment debt
eststo m11: quietly xtreg Dinvdebttoinc c.dgini#i.Leasyraise i.Leasyraise $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Leasyraise i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m12: quietly xtreg Dcardebttoinc c.dgini#i.Leasyraise i.Leasyraise $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Leasyraise i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//Panel G: Effects on Investment Debt and Car Debt - by Financial Risk

*Investment debt
eststo m13: quietly xtreg Dinvdebttoinc c.dgini#i.Lfinrisk i.Lfinrisk $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lfinrisk i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car Debt
eststo m14: quietly xtreg Dcardebttoinc c.dgini#i.Lfinrisk i.Lfinrisk $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lfinrisk i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)


*save table
esttab m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 m11 m12 m13 m14 using "Tables\Baseline Results.csv",  b(2) se(2) keep(*dgini*) margin title(Debt regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps



